\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{jmo}[2022/05/18 JMO class]

% Fonty a jazyk
\RequirePackage[utf8]{inputenc}
\RequirePackage[czech]{babel}
\RequirePackage{amsmath,amsfonts,amssymb}
\RequirePackage{url}
\renewcommand{\familydefault}{ptm}

% Geometrie, grafika a dalsi
\LoadClass[a4paper,10pt]{article}
\RequirePackage[a4paper,
				twoside,
				left=15mm, right=10mm,
				textwidth=185mm,
				top=20mm, bottom=20mm]{geometry}
\setlength{\columnsep}{5mm}
\setlength{\parindent}{5mm}
\setlength{\fboxsep}{1mm}

\RequirePackage{multicol}
\RequirePackage{multirow}
\RequirePackage{graphicx}
\RequirePackage{tabularx, tabularray}
\RequirePackage[format=plain, %
				textformat=simple, %
				labelformat=simple, %
				justification=centering, %
				labelsep=quad, %
				figurename=Obr., %
				font={small, stretch=0.8}, %
				singlelinecheck=off, %
				skip=5pt, %
				tablename=Tab.]{caption}
\captionsetup[table]{justification=justified}

\DeclareCaptionLabelFormat{r-parens}{#2)}
\RequirePackage[labelformat=simple,%
				position=top,%
				justification=raggedright,%
				labelformat=r-parens]{subcaption}
%\renewcommand\thesubfigure{\alph{subfigure})} % (a) –> a)
%\renewcommand\thesubfigure{\alph{subfigure}} % (a) –> a

\newcommand{\figocw}{86mm}
\newcommand{\figtcw}{181mm}

\RequirePackage{float}
\RequirePackage{hyperref}
\RequirePackage{lipsum}
\RequirePackage{enumitem}
\RequirePackage[square,numbers,sort&compress]{natbib}
\bibliographystyle{unsrturl}
\setlength{\bibsep}{0pt plus 0.3ex}

\newcommand{\reffig}[1]{\textit{obr.~\ref{#1}}}
\newcommand{\refFig}[1]{\textit{Obr.~\ref{#1}}}
\newcommand{\reftab}[1]{\textit{tab.~\ref{#1}}}
\newcommand{\refTab}[1]{\textit{Tab.~\ref{#1}}}
\newcommand{\refeq}[1]{(\ref{#1})}

% Bool prepinace
\RequirePackage{xifthen}
\newboolean{researchpaper}
\setboolean{researchpaper}{false}

% Nadpisy apod.
\RequirePackage{titlesec}
\titleformat{\section}
	{\normalfont\bfseries}
	{\thesection.}
	{.3em}
	{\MakeUppercase}

\titleformat{\subsection}
	{\normalfont\bfseries}
	{\thesubsection}
	{.3em}
	{}

\titleformat{\subsubsection}
	{\normalfont\bfseries\it}
	{\thesubsubsection}
	{.3em}
	{}

\titlespacing*{\section}
	{0pt}
	{1ex plus .1ex minus .1ex}
	{.5ex plus .1ex minus .1ex}
\titlespacing*{\subsection}
	{0pt}
	{1ex plus .1ex minus .1ex}
	{.5ex plus .1ex minus .1ex}
\titlespacing*{\subsubsection}
	{0pt}
	{0.5ex plus .0ex minus .0ex}
	{.5ex plus .0ex minus .0ex}

% Autori
\RequirePackage{authblk}
\setlength{\affilsep}{0em}
\renewcommand\Authfont{\normalfont}
\renewcommand\Authsep{, }
\renewcommand\Authand{, }
\renewcommand\Authands{, }

% Autori jako seznam do anotace
\newcommand*{\authlist}[1]{\gdef\@authlist{#1}}
\newcommand*{\@authlist}{\string\authlist}

% Prikazy pro tvorbu hlavicky
\renewcommand*{\abstract}[1]{\gdef\@abstract{#1}}
\newcommand*{\@abstract}{\string\abstract}

\newcommand*{\keywords}[1]{\gdef\@keywords{#1}}
\newcommand*{\@keywords}{\string\keywords}

\newcommand*{\engtitle}[1]{\gdef\@engtitle{#1}}
\newcommand*{\@engtitle}{\string\engtitle}

\newcommand*{\engabstract}[1]{\gdef\@engabstract{#1}}
\newcommand*{\@engabstract}{\string\engabstract}

\newcommand*{\engkeywords}[1]{\gdef\@engkeywords{#1}}
\newcommand*{\@engkeywords}{\string\engkeywords}

% Hlavicka
\renewcommand*{\maketitle}
{
\noindent{\@author}\par
\vspace{5mm}
\noindent{\bf \LARGE \@title}\par
\vspace{3mm}
\leftskip 40mm {\noindent \it \@abstract}\par
\vspace{1mm}
\noindent {\bf Klíčová slova:} \@keywords\par
\leftskip 0mm
\vspace{5mm}
}

% Kontaktni informace
\newcommand*{\contacts}[1]{\gdef\@contacts{#1}}
\newcommand*{\@contacts}{\string\contacts}

\newcommand*{\putcontacts}
{
\vspace{5mm}
\noindent\@contacts
}

\newcommand*{\putresearch}
{
\ifthenelse{\boolean{researchpaper}}{
	\vspace{5mm}
	\noindent\textbf{\emph{Jedná se o vědecký článek}}
	}{}
}

% Podekovani
\newcommand*{\acknowledgement}[1]{\gdef\@acknowledgement{#1}}
\newcommand*{\@acknowledgement}{\string\acknowledgement}

\newcommand*{\putacknowledgement}
{
\vspace{5mm}
\noindent\textbf{\emph{\@acknowledgement}}
\vspace{2mm}
}

% Anotace (anglicky abstrakt, apod.)
\newcommand*{\makeannotation}
{
\pagebreak
\begin{minipage}{8.7cm}
\noindent{\bf \@engtitle} (\@authlist)\dotfill{}XX\par
\noindent{\@engabstract}\par
\noindent{{\bf Keywords:} \@engkeywords}
\end{minipage}
}

% Vypnout cislovani stranek
\pagenumbering{gobble}